-- Scripted Track View Utility plugins
-- ***********************************************
-- Created By Adam Felt
-- Modify at your own risk.
-- ***********************************************

plugin TrackViewUtility SoftSelectionManager
	name:~NAME_SOFT_SELECTION_SETTINGS_MANAGER~
	category:~SCRIPTED_TV_UTILITIES_CATEGORY~
	classID:#(0x9ba0d47b, 0xcd3f255f)
(

 	rollout SoftSelectParams ~SOFTSELECTPARAMS_CAPTION~ width:~SOFTSELECTPARAMS_WIDTH~ height:~SOFTSELECTPARAMS_HEIGHT~
	(
		local tv
		local closing = false
		
		checkbutton useSoftSelect ~USESOFTSELECT_CAPTION~ pos:~USESOFTSELECT_POSITION~ width:~USESOFTSELECT_WIDTH~ height:20
		spinner range ~RANGE_SPINNER_CAPTION~ pos:~RANGE_SPINNER_POSITION~ width:~RANGE_SPINNER_WIDTH~ height:20 range:[0,99999,10] type:#integer
		spinner falloff ~FALLOFF_SPINNER_CAPTION~ pos:~FALLOFF_SPINNER_POSITION~ width:70 height:20 range:[0.01,10.0,1.0] scale:0.01 type:#float
		
		on SoftSelectParams open do
		(
			tv = trackviews.current
			if tv != undefined do 
			(
				useSoftSelect.state = tv.useSoftSelect
				range.value = tv.softSelectRange
				falloff.value = tv.softSelectFalloff
			)
		)
		on SoftSelectParams closed do
		(
			if trackviews.current != undefined do
			(
				trackviews.current.closeUtility ~SOFT_SEL_SETTINGS_MANAGER~
			)
		)

		on useSoftSelect changed state do
		(
			if tv == undefined do
				tv = trackviews.current
			if tv != undefined do
				tv.useSoftSelect = state
		)
		on range changed value do
		(
			if tv == undefined do
				tv = trackviews.current
			if tv != undefined do
				tv.softSelectRange = value
		)
		on falloff changed value do
		(
			if tv == undefined do
				tv = trackviews.current
			if tv != undefined do
				tv.softSelectFalloff = value
		)
		on SoftSelectParams close do
		(
			if trackviews.current != undefined do
			(
				closing = true
				trackviews.current.closeUtility ~CURRENT_VALUE_EDITOR~
			)
		)

	)
	on Init val do
	(
		tv = val
		if tv != undefined do
		(
			createDialog SoftSelectParams parent:tv.ui.hwnd -- pos:[100,100]
			cui.registerDialogBar SoftSelectParams parent:tv.ui.hwnd style:#(#cui_dock_horz, #cui_floatable, #cui_handles) minSize:[240,30] maxSize:[240,30]
			SoftSelectParams.closing = false
		)
	)
	
	on TrackViewClosed do
	(
		if SoftSelectParams != undefined do (
			if SoftSelectParams.closing == false do (
				cui.UnregisterDialogBar SoftSelectParams
				destroyDialog SoftSelectParams
			)
		)
	)
	
	on keySelectionChanged do
	(
		if trackviews.current != undefined do
			SoftSelectParams.useSoftSelect.state = trackviews.current.useSoftSelect
	)
)

-- Current Value Editor
-- Transform type-in functionality for selected tracks
-- Lets you edit the value of selected tracks at the current frame.  
plugin TrackViewUtility KeyValueUtility
	name:~NAME_CURRENT_VALUE_EDITOR~
	category:~SCRIPTED_TV_UTIL_CATEGORY~
	classID:#(0x57088e0e, 0x50b6e750)
(

	rollout valueRollout ~VALUEROLLOUT_CURRENT_VALUE~ width:~VALUEROLLOUT_WIDTH~ height:~VALUEROLLOUT_HEIGHT~
	(
		radiobuttons editMode "" pos:[12,6] width:63 height:32 labels:#(~EDITMODE_CAPTION~, ~EDITMODE_CAPTION2~) columns:1
		GroupBox valueGroup ~VALUEGROUP_FLOAT_CAPTION~ pos:[7,44] width:105 height:96
		spinner xvalue ~XVALUE_X_CAPTION~ pos:~XVALUE_POSITION~ width:~XVALUE_WIDTH~ height:16 range:[-1e+007,1e+008,0] type:#float
		spinner yValue ~YVALUE_CAPTION~ pos:~YVALUE_POSITION~ width:~YVALUE_WIDTH~ height:16 range:[-1e+007,1e+008,0] type:#float
		spinner zValue ~ZVALUE_CAPTION~ pos:~ZVALUE_POSITION~ width:~ZVALUE_WIDTH~ height:16 range:[-1e+007,1e+008,0] type:#float
		local origValue = 0.0
		local tv
		local closing = false
		
		fn UpdateValue =
		(
--			print ~PRINT_UPDATING~
			-- defines that show selected controller type commonality
			local UNDEFINED_CONTROL = 0
			local FLOAT_CONTROL = 1
			local POINT3_CONTROL = 2
			local MIXED_CONTROL = 16
			local type = UNDEFINED_CONTROL
			
			xValue.value = 0.0
			yValue.value = 0.0
			zValue.value = 0.0
			
			tv = trackviews.current
			if tv == undefined then
			(
				print ~PRINT_NO_TV_INTERFACE~
				return 0
			)
			
			for i in 1 to tv.numSelTracks() do
			(
				curControl = (tv.getSelected i)
				
				if ((SuperClassOf curControl) == FloatController) then 
				(
					if (type == UNDEFINED_CONTROL) then
					(
						if editMode.state != 2 do xValue.value = curControl.value
						type = FLOAT_CONTROL
					) 
					else
					(
						if (type == FLOAT_CONTROL) then
						(
							if xValue.value != curControl.value And editMode.state != 2 do
							(
								xValue.value = 0.0
							)
						)
						else
						(
							type = MIXED_CONTROL
						)
					)
				)

				-- Look for common position controllers
				else 
				(
					if ((SuperClassOf curControl) == PositionController or (SuperClassOf curControl) == Point3Controller or
						(SuperClassOf curControl) == RotationController or (SuperClassOf curControl) == ScaleController) then
					(
						if type == UNDEFINED_CONTROL then
						(
							if editMode.state != 2 do
							(
								xValue.value = curControl.value.x
								yValue.value = curControl.value.y
								zValue.value = curControl.value.z
							)
							type = POINT3_CONTROL
						)
						else 
						(
							if type == POINT3_CONTROL then
							(
								if xValue.value != curControl.value And editMode.state != 2 do
								(
									xValue.value = 0.0
									yValue.value = 0.0
									zValue.value = 0.0
								)
							)
							else
							(
								type = MIXED_CONTROL
							)
						)
					)
					else 
					(
						type= MIXED_CONTROL
					)
				)
				if type == MIXED_CONTROL  or type == UNDEFINED_CONTROL do
				(
					height = 135
					valueGroup.caption = ~VALUEGROUP_CAPTION_MIXED~
					xvalue.caption = ""
					xvalue.enabled = false
					yvalue.enabled = false
					zvalue.enabled = false
					xvalue.caption = ""
					yvalue.caption = ""
					zvalue.caption = ""
				)
				if type == FLOAT_CONTROL do
				(
					height = 80
					valueGroup.caption = ~VALUEGROUP_CAPTION_FLOAT~
					xvalue.enabled = true
					yvalue.enabled = false
					zvalue.enabled = false
					xvalue.caption = ""
					yvalue.caption = ""
					zvalue.caption = ""
					
				)
				if type == POINT3_CONTROL do
				(
					height = 135
					valueGroup.caption = "Point3"
					xvalue.caption = ~XVALUE_CAPTION~
					yvalue.caption = ~YVALUE_CAPTION_Y~
					zvalue.caption = ~ZVALUE_CAPTION_Z~
					xvalue.enabled = true
					yvalue.enabled = true
					zvalue.enabled = true
				)
			)
			if editMode.state == 2 then -- relative mode
			(
				xValue.value = 0.0
				yValue.value = 0.0
				zValue.value = 0.0
			)

		)
		
		fn setCurrentValue axis = 
		(
--			print ~PRINT_SETTINGS~
			tv = trackviews.current
			if tv == undefined then
			(
				return 0
			)
			
			trackCount = tv.numSelTracks()
			for i in 1 to trackCount do
			(
				curControl = (tv.getSelected i)
				if ((SuperClassOf curControl) == FloatController) then 
				(
					if (editMode.state == 1) then
					(
						curControl.value = xvalue.value
					)
					else
					(
						curControl.value += xvalue.value - origValue
						if i == trackCount do origValue = xvalue.value
					)
				)
				else
				(
					if (editMode.state == 1) then
					(
						if axis == 1 do 
						(
							curControl.value.x = xvalue.value
						)
						if axis == 2 do 
						(
							curControl.value.y = yvalue.value
						)
						if axis == 3 do 
						(
							curControl.value.z = zvalue.value
						)
					)
					else
					(
						if axis == 1 do 
						(
							curControl.value.x += xvalue.value - origValue
							if i == trackCount do origValue = xvalue.value
						)
						if axis == 2 do 
						(
							curControl.value.y += yvalue.value - origValue
							if i == trackCount do origValue = yvalue.value
						)
						if axis == 3 do 
						(
							curControl.value.z += zvalue.value - origValue
							if i == trackCount do origValue = zvalue.value
						)
					)
				)
			)
		)
		
		on valueRollout close do
		(
			if trackviews.current != undefined do
			(
				closing = true
				trackviews.current.closeUtility ~CURRENT_VALUE_EDITOR_CAPTION~
			)
		)
		on editMode changed state do
		(
			if state == 2 then
			(
				xValue.value = 0.0
				yValue.value = 0.0
				zValue.value = 0.0
			)
			else
			(
				UpdateValue()
			)
		)
		on xvalue changed val do
		(
			setCurrentValue 1
		)
		on xvalue buttondown do
		(
			origValue = 0.0
		)
		on xvalue buttonup do
		(
			origValue = 0.0
			if (editMode.state == 2) do
			(
				xvalue.value = 0.0
			)
		)
		on yValue changed val do
		(
			setCurrentValue 2
		)
		on yValue buttondown do
		(
			origValue = 0.0
		)
		on yValue buttonup do
		(
			origValue = 0.0
			if (editMode.state == 2) do
			(
				yvalue.value = 0.0
			)
		)
		on zValue changed val do
		(
			setCurrentValue 3
		)
		on zValue buttondown do
		(
			origValue = 0.0
		)
		on zValue buttonup do
		(
			origValue = 0.0
			if (editMode.state == 2) do
			(
				zvalue.value = 0.0
			)
		)
	)

	on create do
	(
--		print ~PRINT_CREATING_CAPTION~
	)

	on trackSelectionChanged do
	(
--		print ~PRINT_TRACK_SELECTION_CHANGED~
		valueRollout.UpdateValue()
	)
	on nodeSelectionChanged do
	(
--		print ~PRINT_NODE_SELECTION_CHANGED~
	)
	on keySelectionChanged do
	(
--		print ~PRINT_KEY_SELECTION_CHANGED~
	)
	on timeSelectionChanged do
	(
--		print ~PRINT_TIME_SELECTION_CHANGED~
	)
	on MajorModeChanged do
	(
--		print ~PRINT_MAJOR_MODE_CHANGED~
	)
	on TrackListChanged do
	(
--		print ~PRINT_TRACK_LIST_CHANGED~
	)
	
	on TrackViewClosed do
	(
		if valueRollout != undefined do (
			if valueRollout.closing == false do (
				cui.UnregisterDialogBar valueRollout
				destroyDialog valueRollout
			)
		)
	)
	
	on Init val do 
	(
		if val != undefined do 
		(
			valueRollout.tv = val
			createDialog valueRollout parent:(val.ui.hwnd)
			cui.registerDialogBar valueRollout parent:val.ui.hwnd
			valueRollout.closing = false
			valueRollout.updateValue()
		)
	)
)




